# nsef_fix: A script to teach skill 9784 to actors who meet the conditions
def nsef_fix
  # Custom method to check if an actor's class level is over a certain value
#  def actor_class_level_over?(actor_id, class_id, level)
#    return false unless $game_actors.exist?(actor_id)
#
#    actor = $game_actors[actor_id]
#    return false if actor.level_list[class_id].nil?
#
#    level <= actor.level_list[class_id]
#  end

  # Custom method to check if an actor has a specific skill
#  def actor_skill_have?(actor_id, skill_id)
#    skill = $data_skills[skill_id]
#    return false if skill.nil?
#    return false unless $game_actors.exist?(actor_id)
#
#    $game_actors[actor_id].skill_learn?(skill) || $game_actors[actor_id].all_abilities.include?(skill_id)
#  end

  # Gather all party members (including backrow)
  party_members = $game_party.all_members

  # Iterate through each party member
  party_members.each do |actor|
    # Check if the actor's class level is over 2 for class ID 7024
    if actor_class_level_over?(actor.id, 7024, 2)
      # Check if the actor does NOT have skill ID 9784
      unless actor_skill_have?(actor.id, 9784)
        # Learn skill ID 9784
        actor.learn_skill(9784)
        # Show a message: "Actor name learned skill name"
        skill_name = $data_skills[9784].name
        $game_message.add("#{actor.name} learned \\I[227]\\C[1]#{skill_name}\\C[0]!")
      end
    end
  end
end